/*
 * Decompiled with CFR 0.152.
 */
package dev.zy.sensorboard.processor;

import dev.zy.sensorboard.gui.Client;
import dev.zy.sensorboard.processor.Processor;
import dev.zy.sensorboard.processor.SerialProcessor;

public class PeriodicRecorder
extends Thread {
    private Processor proc;
    private int gap;
    private int time;
    private boolean running;
    private Client mG;

    public PeriodicRecorder(Processor proc, int hertz, int time, Client mG) {
        this.proc = proc;
        this.gap = (int)(1.0 / (double)hertz * 1000.0);
        this.time = time * hertz;
        this.running = true;
        this.mG = mG;
        if (proc.getClass().equals(SerialProcessor.class)) {
            this.gap -= 100;
        }
    }

    public Processor getProc() {
        return this.proc;
    }

    public void setProc(Processor proc) {
        this.proc = proc;
    }

    @Override
    public void run() {
        this.running = true;
        for (int i = 0; i < this.time; ++i) {
            if (!this.running) {
                return;
            }
            this.mG.addRecord(this.proc.getRGB());
            try {
                PeriodicRecorder.sleep(this.gap);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void terminate() {
        this.running = false;
    }
}

